/*
 * Decompiled with CFR 0.152.
 */
package org.cef.browser;

import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.image.BufferedImage;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.montoyo.mcef.MCEF;
import net.montoyo.mcef.api.IBrowser;
import net.montoyo.mcef.api.IStringVisitor;
import net.montoyo.mcef.client.ClientProxy;
import net.montoyo.mcef.client.StringVisitor;
import net.montoyo.mcef.client.UnsafeUtil;
import net.montoyo.mcef.utilities.Log;
import org.apache.commons.lang3.NotImplementedException;
import org.cef.CefClient;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefBrowser_N;
import org.cef.browser.CefRenderer;
import org.cef.browser.CefRequestContext;
import org.cef.callback.CefDragData;
import org.cef.handler.CefRenderHandler;
import org.cef.handler.CefScreenInfo;
import org.lwjgl.BufferUtils;
import org.lwjgl.glfw.GLFW;

public class CefBrowserOsr
extends CefBrowser_N
implements CefRenderHandler,
IBrowser {
    private CefRenderer renderer_;
    private long window_handle_ = 0L;
    private boolean justCreated_ = false;
    private Rectangle browser_rect_ = new Rectangle(0, 0, 1, 1);
    private Point screenPoint_ = new Point(0, 0);
    private double scaleFactor_ = 1.0;
    private int depth = 32;
    private int depth_per_component = 8;
    private boolean isTransparent_;
    public static final Component dc_ = new Component(){

        @Override
        public Point getLocationOnScreen() {
            return new Point(0, 0);
        }
    };
    private MouseEvent lastMouseEvent = new MouseEvent(dc_, 503, 0L, 0, 0, 0, 0, false);
    public static boolean CLEANUP = true;
    private static final Map<Integer, Character> WORST_HACK = new HashMap<Integer, Character>();
    private final PaintData paintData = new PaintData();
    private static HashMap<Integer, Long> CURSORS = new HashMap();
    boolean canChangeCursor = false;
    int currentCursor;
    Consumer<Integer> onCursorChanged = i -> {};

    public CefBrowserOsr(CefClient client, String url, boolean transparent, CefRequestContext context) {
        this(client, url, transparent, context, null, null);
    }

    public CefBrowserOsr(CefClient client, String url, boolean transparent, CefRequestContext context, CefBrowserOsr parent, Point inspectAt) {
        super(client, url, context, parent, inspectAt);
        this.isTransparent_ = transparent;
        this.renderer_ = new CefRenderer(transparent);
    }

    @Override
    public void createImmediately() {
        this.justCreated_ = true;
        this.createBrowserIfRequired(false);
    }

    @Override
    public Component getUIComponent() {
        return dc_;
    }

    @Override
    public CefRenderHandler getRenderHandler() {
        return this;
    }

    @Override
    protected CefBrowser_N createDevToolsBrowser(CefClient client, String url, CefRequestContext context, CefBrowser_N parent, Point inspectAt) {
        return new CefBrowserOsr(client, url, this.isTransparent_, context, this, inspectAt);
    }

    @Override
    public Rectangle getViewRect(CefBrowser browser) {
        return this.browser_rect_;
    }

    @Override
    public Point getScreenPoint(CefBrowser browser, Point viewPoint) {
        Point screenPoint = new Point(this.screenPoint_);
        screenPoint.translate(viewPoint.x, viewPoint.y);
        return screenPoint;
    }

    @Override
    public void onPopupShow(CefBrowser browser, boolean show) {
        if (!show) {
            this.renderer_.clearPopupRects();
            this.invalidate();
        }
    }

    @Override
    public void onPopupSize(CefBrowser browser, Rectangle size) {
        this.renderer_.onPopupSize(size);
    }

    @Override
    public void close() {
        if (CLEANUP) {
            ((ClientProxy)MCEF.PROXY).removeBrowser(this);
            this.renderer_.cleanup();
        }
        super.close(true);
    }

    @Override
    public void resize(int width, int height) {
        this.browser_rect_.setBounds(0, 0, width, height);
        dc_.setBounds(this.browser_rect_);
        dc_.setVisible(true);
        this.wasResized(width, height);
    }

    @Override
    public void draw(PoseStack matrixStack, double x1, double y1, double x2, double y2) {
        this.renderer_.render(matrixStack, x1, y1, x2, y2);
    }

    @Override
    public int getTextureID() {
        return this.renderer_.texture_id_[0];
    }

    @Override
    public void injectMouseMove(int x, int y, int mods, boolean left) {
        MouseEvent ev;
        this.lastMouseEvent = ev = new MouseEvent(dc_, 503, 0L, mods, x, y, 0, false);
        this.sendMouseEvent(ev);
    }

    @Override
    public void injectMouseButton(int x, int y, int mods, int btn, boolean pressed, int ccnt) {
        if (btn != 3) {
            MouseEvent ev = new MouseEvent(dc_, pressed ? 501 : 502, 0L, mods, x, y, ccnt, false, btn);
            this.sendMouseEvent(ev);
        } else {
            MouseEvent ev = new MouseEvent(dc_, pressed ? 501 : 502, 0L, 4096, x, y, ccnt, false, 3);
            this.sendMouseEvent(ev);
        }
        if (!this.safeMode) {
            this.setSafeMode(true);
            this.setFocus(true);
            this.setSafeMode(false);
        } else {
            this.setFocus(true);
        }
    }

    public int remapModifiers(int mods) {
        int vkMods = 0;
        if ((mods & 2) != 0) {
            vkMods |= 0x82;
        }
        if ((mods & 4) != 0) {
            vkMods |= 0x208;
        }
        if ((mods & 1) != 0) {
            vkMods |= 0x41;
        }
        if ((mods & 8) != 0) {
            vkMods |= 0x104;
        }
        return vkMods;
    }

    public static int remapKeycode(int kc, char c, int mod) {
        switch (kc) {
            case 256: {
                return 27;
            }
            case 258: {
                return 9;
            }
        }
        int ck = CefBrowserOsr.getChar(kc, 0, mod);
        if (ck == 0) {
            return c;
        }
        return ck;
    }

    public static int getChar(int keyCode, int scanCode, int mod) {
        if (keyCode == 341) {
            return 65535;
        }
        if (keyCode == 345) {
            return 65535;
        }
        switch (keyCode) {
            case 10: 
            case 257: 
            case 335: {
                return 10;
            }
            case 32: {
                return 32;
            }
            case 259: {
                return 8;
            }
            case 261: {
                return 127;
            }
            case 262: 
            case 263: 
            case 264: 
            case 265: 
            case 266: 
            case 267: 
            case 268: 
            case 269: {
                return 65535;
            }
        }
        String keystr = GLFW.glfwGetKeyName((int)keyCode, (int)scanCode);
        if (keystr == null) {
            keystr = "\u0000";
        } else if (keystr.length() == 0) {
            return -1;
        }
        return keyCode;
    }

    private long mapScanCode(int key, char c) {
        if (key == 341 || key == 345) {
            return 29L;
        }
        return switch (key) {
            case 261 -> 83L;
            case 263 -> 75L;
            case 264 -> 80L;
            case 265 -> 72L;
            case 262 -> 77L;
            case 267 -> 81L;
            case 266 -> 73L;
            case 269 -> 79L;
            case 268 -> 71L;
            case 10, 257, 335 -> 28L;
            default -> GLFW.glfwGetKeyScancode((int)key);
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void injectKeyPressedByKeyCode(int key, char c, int mods) {
        if (c != '\u0000') {
            Map<Integer, Character> map = WORST_HACK;
            synchronized (map) {
                WORST_HACK.put(key, Character.valueOf(c));
            }
        }
        if (mods == 2) {
            if (key == 82) {
                this.reload();
                return;
            }
            if (key == 61) {
                if (this.getZoomLevel() < 9.0) {
                    this.setZoomLevel(this.getZoomLevel() + 1.0);
                }
                return;
            }
            if (key == 45) {
                if (this.getZoomLevel() > -9.0) {
                    this.setZoomLevel(this.getZoomLevel() - 1.0);
                }
                return;
            }
            if (key == 48) {
                this.setZoomLevel(0.0);
                return;
            }
        } else if (mods == 4) {
            if (key == 263 && this.canGoBack()) {
                this.goBack();
                return;
            }
            if (key == 262 && this.canGoForward()) {
                this.goForward();
                return;
            }
        }
        switch (key) {
            case 259: 
            case 260: 
            case 262: 
            case 263: 
            case 264: 
            case 265: 
            case 266: 
            case 267: 
            case 268: 
            case 269: 
            case 280: 
            case 281: 
            case 282: 
            case 283: 
            case 284: 
            case 322: 
            case 324: 
            case 326: 
            case 328: {
                KeyEvent ev = UnsafeUtil.makeEvent(dc_, CefBrowserOsr.remapKeycode(key, '\uffff', mods), '\uffff', 0, 401, 0L, this.remapModifiers(mods), this.mapScanCode(key, c));
                this.sendKeyEvent(ev);
                break;
            }
            default: {
                KeyEvent ev;
                int raw = key;
                if (c == '\n') {
                    raw = 13;
                }
                if ((ev = UnsafeUtil.makeEvent(dc_, CefBrowserOsr.remapKeycode(key, c, mods), c, 0, 401, 0L, this.remapModifiers(mods), this.mapScanCode(key, c), raw)).getKeyChar() == '\n') {
                    System.out.println(ev);
                }
                this.sendKeyEvent(ev);
            }
        }
    }

    @Override
    public void injectKeyTyped(int key, int mods) {
        if (mods == 2) {
            if (key == 82) {
                return;
            }
            if (key == 61) {
                return;
            }
            if (key == 45) {
                return;
            }
            if (key == 48) {
                return;
            }
        } else if (mods == 4) {
            if (key == 263 && this.canGoBack()) {
                return;
            }
            if (key == 262 && this.canGoForward()) {
                return;
            }
        }
        char c = (char)key;
        int keyRemapped = CefBrowserOsr.remapKeycode(key, (char)key, mods);
        if (key != 0) {
            switch (key) {
                case 259: 
                case 260: 
                case 262: 
                case 263: 
                case 264: 
                case 265: 
                case 266: 
                case 267: 
                case 268: 
                case 269: 
                case 280: 
                case 281: 
                case 282: 
                case 283: 
                case 284: 
                case 322: 
                case 324: 
                case 326: 
                case 328: {
                    KeyEvent ev = UnsafeUtil.makeEvent(dc_, keyRemapped, '\uffff', 0, 400, 0L, this.remapModifiers(mods), this.mapScanCode(keyRemapped, c));
                    this.sendKeyEvent(ev);
                    break;
                }
                case 10: 
                case 257: 
                case 335: {
                    int raw = key;
                    if (c == '\n') {
                        raw = 13;
                    }
                    KeyEvent ev = UnsafeUtil.makeEvent(dc_, key, '\n', 0, 400, 0L, this.remapModifiers(mods), this.mapScanCode(key, c), raw);
                    this.sendKeyEvent(ev);
                    break;
                }
                default: {
                    KeyEvent ev = UnsafeUtil.makeEvent(dc_, keyRemapped, c, 0, 400, 0L, this.remapModifiers(mods), this.mapScanCode(keyRemapped, c));
                    this.sendKeyEvent(ev);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void injectKeyReleasedByKeyCode(int key, char c, int mods) {
        if (mods == 2) {
            if (key == 82) {
                return;
            }
            if (key == 61) {
                return;
            }
            if (key == 45) {
                return;
            }
            if (key == 48) {
                return;
            }
        } else if (mods == 4) {
            if (key == 263 && this.canGoBack()) {
                return;
            }
            if (key == 262 && this.canGoForward()) {
                return;
            }
        }
        if (c == '\u0000') {
            Map<Integer, Character> map = WORST_HACK;
            synchronized (map) {
                c = WORST_HACK.getOrDefault(key, Character.valueOf('\u0000')).charValue();
            }
        }
        switch (key) {
            case 259: 
            case 260: 
            case 262: 
            case 263: 
            case 264: 
            case 265: 
            case 266: 
            case 267: 
            case 268: 
            case 269: 
            case 280: 
            case 281: 
            case 282: 
            case 283: 
            case 284: 
            case 322: 
            case 324: 
            case 326: 
            case 328: {
                KeyEvent ev = UnsafeUtil.makeEvent(dc_, CefBrowserOsr.remapKeycode(key, '\uffff', mods), c, 0, 402, 0L, this.remapModifiers(mods), this.mapScanCode(key, c));
                this.sendKeyEvent(ev);
                break;
            }
            default: {
                KeyEvent ev = UnsafeUtil.makeEvent(dc_, CefBrowserOsr.remapKeycode(key, c, mods), c, 0, 402, 0L, this.remapModifiers(mods), this.mapScanCode(key, c));
                this.sendKeyEvent(ev);
            }
        }
    }

    @Override
    public void injectMouseWheel(int x, int y, int mods, int amount, int rot) {
        if (mods == 2) {
            if (amount > 0) {
                if (this.getZoomLevel() < 9.0) {
                    this.setZoomLevel(this.getZoomLevel() + 1.0);
                }
            } else if (this.getZoomLevel() > -9.0) {
                this.setZoomLevel(this.getZoomLevel() - 1.0);
            }
            return;
        }
        rot = 32;
        MouseWheelEvent ev = new MouseWheelEvent(dc_, 507, 0L, mods, x, y, 0, false, 0, amount *= 3, rot);
        this.sendMouseWheelEvent(ev);
    }

    @Override
    public void runJS(String script, String frame) {
        this.executeJavaScript(script, frame, 0);
    }

    @Override
    public void visitSource(IStringVisitor isv) {
        this.getSource(new StringVisitor(isv));
    }

    @Override
    public boolean isPageLoading() {
        return this.isLoading();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onPaint(CefBrowser browser, boolean popup, Rectangle[] dirtyRects, ByteBuffer buffer, int width, int height) {
        if (popup) {
            return;
        }
        int size = width * height << 2;
        PaintData paintData = this.paintData;
        synchronized (paintData) {
            if (buffer.limit() > size) {
                Log.warning("Skipping MCEF browser frame, data is too heavy", new Object[0]);
            } else {
                if (this.paintData.hasFrame) {
                    this.paintData.fullReRender = true;
                }
                if (this.paintData.buffer == null || size != this.paintData.buffer.capacity()) {
                    this.paintData.buffer = BufferUtils.createByteBuffer((int)size);
                }
                if (MCEF.ZERO_BUFFER) {
                    BufferUtils.zeroBuffer((ByteBuffer)this.paintData.buffer);
                }
                this.paintData.buffer.position(0);
                this.paintData.buffer.limit(buffer.limit());
                buffer.position(0);
                this.paintData.buffer.put(buffer);
                this.paintData.buffer.position(0);
                this.paintData.width = width;
                this.paintData.height = height;
                this.paintData.dirtyRects = dirtyRects;
                this.paintData.hasFrame = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mcefUpdate() {
        PaintData paintData = this.paintData;
        synchronized (paintData) {
            if (this.paintData.hasFrame) {
                this.renderer_.onPaint(false, this.paintData.dirtyRects, this.paintData.buffer, this.paintData.width, this.paintData.height, this.paintData.fullReRender);
                this.paintData.hasFrame = false;
                this.paintData.fullReRender = false;
            }
        }
    }

    public static long getCursor(int type) {
        if (CURSORS.containsKey(type)) {
            return CURSORS.get(type);
        }
        long cur = GLFW.glfwCreateStandardCursor((int)(switch (type) {
            case 1 -> 221187;
            case 2 -> 221186;
            case 8, 9 -> 221190;
            case 10, 11 -> 221189;
            case 4, 7 -> 221192;
            case 5, 6 -> 221191;
            case 12 -> 221188;
            case 13 -> 221193;
            default -> 0;
        }));
        CURSORS.put(type, cur);
        return cur;
    }

    @Override
    public void allowCursorChanges(boolean value) {
        this.canChangeCursor = value;
        if (value) {
            this.onCursorChange(this, this.currentCursor);
        }
    }

    @Override
    public void addCursorChangeListener(Consumer<Integer> listener) {
        this.onCursorChanged = listener;
    }

    @Override
    public boolean onCursorChange(CefBrowser browser, int cursorType) {
        this.onCursorChanged.accept(cursorType);
        this.currentCursor = cursorType;
        if (!this.canChangeCursor) {
            return true;
        }
        GLFW.glfwSetCursor((long)Minecraft.m_91087_().m_91268_().m_85439_(), (long)CefBrowserOsr.getCursor(cursorType));
        return true;
    }

    @Override
    public boolean startDragging(CefBrowser browser, CefDragData dragData, int mask, int x, int y) {
        return false;
    }

    @Override
    public void updateDragCursor(CefBrowser browser, int operation) {
    }

    private void createBrowserIfRequired(boolean hasParent) {
        if (this.getNativeRef("CefBrowser") == 0L) {
            if (this.getParentBrowser() != null) {
                this.createDevTools(this.getParentBrowser(), this.getClient(), 0L, true, this.isTransparent_, null, this.getInspectAt());
            } else {
                this.createBrowser(this.getClient(), 0L, this.getUrl(), true, this.isTransparent_, null, this.getRequestContext());
            }
        } else {
            this.setFocus(true);
        }
    }

    @Override
    public boolean getScreenInfo(CefBrowser browser, CefScreenInfo screenInfo) {
        screenInfo.Set(this.scaleFactor_, this.depth, this.depth_per_component, false, this.browser_rect_.getBounds(), this.browser_rect_.getBounds());
        return true;
    }

    @Override
    public CompletableFuture<BufferedImage> createScreenshot(boolean nativeResolution) {
        throw new NotImplementedException("createScreenshot not implemented on MCEF");
    }

    private static class PaintData {
        private ByteBuffer buffer;
        private int width;
        private int height;
        private Rectangle[] dirtyRects;
        private boolean hasFrame;
        private boolean fullReRender;

        private PaintData() {
        }
    }
}

